require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require 'rspec'
require 'watir-scroll'
require_relative 'base/base'
require_relative '../helper/table'

class LandingAppointments < Base
  include PageObject

  def initialize(driver)
    super(driver)
  end

  expected_title "VA Appointments"
  button(:refresh, :id =>'refresh-appointments-btn')

  #Add new appointment/request
  button(:add_top_btn, :id =>'heading-new-appointment-request-btn')
  button(:add_bottom_btn, :id=>'new-appointment-request-btn')
  button(:first_appointment, :css=>'#booked-appointments-table-list li:nth-of-type(1) button')
  span(:appointment_btn_label, :css=>'#heading-new-appointment-request-btn .phone-hidden')

  #Requested Appointments#
  h3(:request_header, :id=>"requests")
  p(:request_no_appointment, :css=>"#requested-appointments p.no-appointments")

  elements(:request_table_list, :li, :css => ".requested-appointments-contain ol.table-list-body li")
  elements(:request_table_headers, :span, :css => "#requested-appointments-table-list .table-list-head div")
  div(:noResultsMessage, :css => ".requested-appointments-contain .no-results-message[tabindex]")

  #Appointments#
  h3(:appointment_header, :id=>'booked')
  p(:appointment_no_appointment, :css=>'#booked-appointments-table-list p.no-appointments')

  elements(:appointment_table_list, :li, :css => "#booked-appointments-table-list ol.table-list-body li button")
  elements(:appointment_table_headers, :div, :css => "#booked-appointments-table-list .table-list-head div")
  div(:appointment_noResultsMessage, :css => "#booked-appointments-table-list .no-results-message[tabindex]")
  elements(:list_of_appointment_dates, :span ,:css => '#booked-appointments-table-list ol.table-list-body li span[class=list-cell] .list-cell-data')
  elements(:list_of_appointments, :css=>'#booked-appointments button')

  #Appointment list heading
  div(:appointment_list_heading, :css => '#booked-appointments-table-list > div')


  #Crisis Modal
  button(:get_emergency_btn , :css=>'#crisis-button')
  div(:crisis_modal_content, :css=>'.ui-popup-active .crisis-modal')
  button(:oK_btn, :css => '.ui-popup-active #crisis-modal-okay')
  elements(:crisis_modal_dialouge, :css => "#dialogDesc tr p")
  h3(:modal_header, :css => "#dialogTitle")
  div(:modal_content, :css => "#dialogDesc")

  def clickOnCrisisBannerLink
    link_element = @driver.link(:css => '.ui-popup-active #locatorLink')
    link_element.when_present(TIME_OUT_LIMIT)
    @driver.execute_script("$(arguments[0]).click();",link_element)
  end

  ##CC enabled form
  radio_button(:va_appointments, :css=>'#service-va-appointments')
  radio_button(:cc_appointment, :css=>'#service-community-care-appointments')
  button(:continue_button, :css=>'#continue-btn')

  ##Pagination
  div(:pagination_controls_appointments, :css=>'#booked-appointments #appointments-pagination-top-controls')
  div(:pagination_controls_appointments_bottom, :css=>'#booked-appointments #appointments-pagination-bottom-controls')
  elements(:pagination_navigation, :css=>'#bottom-paginator-div a')
  elements(:pagination_navigation_links, :css=>'#bottom-paginator-div li')


  def getNthRequestTableHeader(col)
    return  request_table_headers_elements[col - 1].text.strip
  end

  def getRequestTextForRowCol(row, col)
    self.class.span(:cell, :css => ".requested-appointments-contain ol.table-list-body li:nth-child(" + row.to_s + ") button span:nth-child(" +  col.to_s + ") .list-cell-hyphen")
    return self.cell_element.text.strip
  end

  def getNthAppointmentTableHeader(col)
    return  appointment_table_headers_elements[col - 1].text.strip
  end

  def getAppointmentTextForRowCol(row, col)
    self.class.span(:cell, :css => "#booked-appointments-table-list ol.table-list-body li:nth-child(" + row.to_s + ") button span:nth-child(" +  (col + 1).to_s + ") .list-cell-data")
    return self.cell_element.text.strip
  end

  def areColumnsSorted?(dateArray)
    sorted = false
    all_appointments_date = []
    dateArray.each do |ele|
      all_appointments_date << [ele.text]
    end

    if((all_appointments_date.uniq).eql?(all_appointments_date.uniq.sort))
      sorted = true
    end
    return sorted
  end

  def verifyAppointmentDetailsInList(all_appointments, appointment_data)
    appointment_present = false
    i =0
    while(i<all_appointments.length)
      if ((all_appointments[i].text.gsub(/\s+/, '')) == appointment_data.gsub(/\s+/, ''))
        appointment_present = true
        break
      end
      i+=1
    end
    return appointment_present
  end

  def openIfAppointmentExists(all_appointments, appointment_data)
    i =0
    while(i<all_appointments.length)
      if ((all_appointments[i].text.gsub(/\s+/, '')) == appointment_data.gsub(/\s+/, ''))
        all_appointments[i].click
        break
      end
      i+=1
    end
  end

  def clickRefresh
    refresh_element.when_present(TIME_OUT_LIMIT)
    wait_until{ !refresh_element.attribute('disabled') }
    self.refresh
  end

  def clickRequest(requestNumber)
    request_details = request_table_list_elements[requestNumber]
    request_details.scroll.to :top
    request_table_list_elements[requestNumber].click
  end

  def clickPage(pageNumber)
    selectOption(pagination_navigation_elements, pageNumber)
  end

  def isPaginationDisplayed()
    element = @driver.element(:css => "#appointments-pagination-top-controls")
    return element.visible?
  end

end